#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int mxN = 3010;
vector<int> adj[mxN];
vector<bool> visited(mxN, false);

void precomp() {
    for (int i = 0; i < mxN; i++) {
        visited[i] = false;
        adj[i].clear();
    }
}

void dfs(int u, int d, pair<int, int> &najdalje) {
    if (visited[u]) {
        return;
    }

    visited[u] = true;
    if (d > najdalje.second) {
        najdalje.first = u;
        najdalje.second = d;
    }

    for (int v : adj[u]) {
        if (!visited[v]) {
            dfs(v, d + 1, najdalje);
        }
    }
}

void solve() {
    int n, k;
    cin >> n >> k;

    for (int i = 1; i <= n; i++) {
        adj[i].clear();
        visited[i] = false;
    }

    for (int i = 0; i < n - 1; i++) {
        int u, v; cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    pair<int, int> najdalje = {-1, 0};
    dfs(1, 0, najdalje);

  //  cout << "START: " << najdalje.first << "\n";

    int start = najdalje.first;
    for (int i = 1; i <= n; i++) visited[i] = false;
    najdalje = {-1, 0};
    dfs(start, 0, najdalje);

 //   cout << "END: " << najdalje.first << "\n";

    int diameter = najdalje.second;
    int edges_left = n - 1 - diameter;
    cout << diameter + min(edges_left, k) << "\n";
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t; cin >> t;
    while(t--) {
   //     precomp();
        solve();
    }
    return 0;
}